<?php

include_once 'conexao.php';
  
class ModeloGrupoDeEstudo
{  
	static public function mdlAddGrupoDeEstudo($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO grupodeestudo
						(descricao, dataCadastro, idCurso, idUsuario) VALUES 
						(:descricao, :dataCadastro, :idCurso, :idUsuario)");
		$stmt->bindParam(":descricao", $dados["descricao"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idCurso", $dados["idCurso"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlAddGrupoDeEstudoEstudante($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO grupodeestudoestudante
						(idGrupoDeEstudo, dataCadastro, idEstudante, idUsuario) VALUES 
						(:idGrupoDeEstudo, :dataCadastro, :idEstudante, :idUsuario)");
		$stmt->bindParam(":idGrupoDeEstudo", $dados["idGrupoDeEstudo"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idEstudante", $dados["idEstudante"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlAddGrupoDeEstudoTrabalho($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO grupodeestudotrabalho
						(temaTrabalho,requisito,idCurso, dataCadastro, dataEntrega, idGrupoDeEstudo, idUsuario) VALUES 
						(:temaTrabalho,:requisito,:idCurso, :dataCadastro, :dataEntrega, :idGrupoDeEstudo, :idUsuario)");
		$stmt->bindParam(":temaTrabalho", $dados["temaTrabalho"], PDO::PARAM_STR);
		$stmt->bindParam(":requisito", $dados["requisito"], PDO::PARAM_STR);
		$stmt->bindParam(":idCurso", $dados["idCurso"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":dataEntrega", $dados["dataEntrega"], PDO::PARAM_STR);
		$stmt->bindParam(":idGrupoDeEstudo", $dados["idGrupoDeEstudo"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}

	static public function mdlMostrarTodosGruposDeEstudoPorDescricaoEPorIdCursto($descricao,$idCurso) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->query("SELECT * FROM grupodeestudo where descricao = '$descricao' and idCurso = '$idCurso' ");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosTrabalhosEmGrupoDoGruposDeEstudoPorTemaTrabalhoEPorIdCurstoEIdGrupoDeEstudo($temaTrabalho,$idCurso,$idGrupoDeEstudo) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->query("SELECT * FROM grupodeestudotrabalho where temaTrabalho = '$temaTrabalho' and idCurso = '$idCurso' and idGrupoDeEstudo = '$idGrupoDeEstudo' ");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosTrabalhosEmGrupoDoGruposDeEstudoPorIdCurstoEIdGrupoDeEstudo($idCurso,$idGrupoDeEstudo) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->query("SELECT * FROM grupodeestudotrabalho where idCurso = '$idCurso' and idGrupoDeEstudo = '$idGrupoDeEstudo' ");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosEstudantesNoGruposDeEstudoPorIdGrupodeEstudoEPorIdEstudante($idGrupoDeEstudo,$idEstudante) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->query("SELECT * FROM grupodeestudoestudante where idGrupoDeEstudo = '$idGrupoDeEstudo' and idEstudante = '$idEstudante' ");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosEstudantesNoGruposDeEstudoPorIdGrupode($idGrupoDeEstudo) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->query("SELECT * FROM grupodeestudoestudante where idGrupoDeEstudo = '$idGrupoDeEstudo'");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosEstudantesNoGruposDeEstudoPorIdGrupodeEstudoEIdEstudante($idGrupoDeEstudo,$idEstudante) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->query("SELECT * FROM grupodeestudoestudante where idGrupoDeEstudo = '$idGrupoDeEstudo' and idEstudante ='$idEstudante'");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosGruposDeEstudoPorIdCurso($idCurso) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->query("SELECT * FROM grupodeestudo where idCurso = '$idCurso'");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarTodosTrabalhosDoGruposDeEstudoPorIdGrupoDeEstudoTrabalho($idGrupoDeEstudoTrabalho) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->query("SELECT * FROM grupodeestudotrabalho where idGrupoDeEstudoTrabalho = '$idGrupoDeEstudoTrabalho'");
			#$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}


	static public function mdlEliminarEstudanteDoGrupoDeEstudo($idGrupoDeEstudo, $idEstudante){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM grupodeestudoestudante where idGrupoDeEstudo = :idGrupoDeEstudo and idEstudante = :idEstudante");
		$stmt->bindParam(":idGrupoDeEstudo", $idGrupoDeEstudo, PDO::PARAM_STR);
		$stmt->bindParam(":idEstudante", $idEstudante, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEliminarGrupoDeEstudoPorIdGrupoDeEstudo($idGrupoDeEstudo){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM grupodeestudo where idGrupoDeEstudo = :idGrupoDeEstudo ");
		$stmt->bindParam(":idGrupoDeEstudo", $idGrupoDeEstudo, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEliminarTrabalhoGrupoDeEstudoPorIdGrupoDeEstudoTrabalho($idGrupoDeEstudoTrabalho){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM grupodeestudo where idGrupoDeEstudoTrabalho = :idGrupoDeEstudoTrabalho ");
		$stmt->bindParam(":idGrupoDeEstudoTrabalho", $idGrupoDeEstudo, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlActualizarNotaDoTrabalhoGrupoDeEstudoPorIdGrupoDeEstudoTrabalho($idGrupoDeEstudoTrabalho, $notaTrabalho){
 
		$stmt = Conexao::conectar()->prepare("UPDATE grupodeestudotrabalho SET notaTrabalho = :notaTrabalho where idGrupoDeEstudoTrabalho = :idGrupoDeEstudoTrabalho ");
		$stmt->bindParam(":idGrupoDeEstudoTrabalho", $idGrupoDeEstudoTrabalho, PDO::PARAM_STR);
		$stmt->bindParam(":notaTrabalho", $notaTrabalho, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlctrFazerUploadTrabalho($idGrupoDeEstudoTrabalho, $arquivo){
 
		$stmt = Conexao::conectar()->prepare("UPDATE grupodeestudotrabalho SET arquivo = :arquivo where idGrupoDeEstudoTrabalho = :idGrupoDeEstudoTrabalho ");
		$stmt->bindParam(":idGrupoDeEstudoTrabalho", $idGrupoDeEstudoTrabalho, PDO::PARAM_STR);
		$stmt->bindParam(":arquivo", $arquivo, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>